/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import com.renyigesai.immortalers_delight.block.ReapCropBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CulturalLegacyEffectToolBlock
extends ReapCropBlock {
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(p_207914_ -> Math.abs(p_207914_.m_123341_()) == 2 || Math.abs(p_207914_.m_123343_()) == 2).map(BlockPos::m_7949_).toList();
    protected static final VoxelShape OUTLINE_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public CulturalLegacyEffectToolBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.m_52305_(pState)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = CulturalLegacyEffectToolBlock.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public int m_7753_(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_214162_(pState, pLevel, pPos, pRandom);
        for (BlockPos blockpos : BOOKSHELF_OFFSETS) {
            if (pRandom.m_188503_(16) != 0 || !CulturalLegacyEffectToolBlock.isValidBookShelf(pLevel, pPos, blockpos)) continue;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 2.0, (double)pPos.m_123343_() + 0.5, (double)((float)blockpos.m_123341_() + pRandom.m_188501_()) - 0.5, (double)((float)blockpos.m_123342_() - pRandom.m_188501_() - 1.0f), (double)((float)blockpos.m_123343_() + pRandom.m_188501_()) - 0.5);
        }
    }

    public static boolean isValidBookShelf(Level pLevel, BlockPos pTablePos, BlockPos pOffsetPos) {
        return pLevel.m_8055_(pTablePos.m_121955_((Vec3i)pOffsetPos)).getEnchantPowerBonus((LevelReader)pLevel, pTablePos.m_121955_((Vec3i)pOffsetPos)) != 0.0f && pLevel.m_8055_(pTablePos.m_7918_(pOffsetPos.m_123341_() / 2, pOffsetPos.m_123342_(), pOffsetPos.m_123343_() / 2)).m_204336_(BlockTags.f_278486_);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    private int maxAgeToolBlocksInRange(Level level, BlockPos centerPos, int range) {
        int maxAge = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    if (!(level.m_8055_(checkPos).m_60734_() instanceof CulturalLegacyEffectToolBlock)) continue;
                    int ageHere = this.m_52305_(level.m_8055_(checkPos));
                    maxAge = maxAge > ageHere + 1 ? maxAge : ageHere + 1;
                }
            }
        }
        return maxAge;
    }

    private static int calculateNewLevel(int originalLevel, int maxAge) {
        int newLevel = originalLevel + 8 + 4 * (maxAge - 1);
        return Math.min(30, newLevel);
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ImmortalersDelightItems.BOWL_OF_MILLENIAN_BAMBOO.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return OUTLINE_SHAPE;
    }

    public List<ItemStack> m_49635_(BlockState p_287732_, LootParams.Builder p_287596_) {
        return super.m_49635_(p_287732_, p_287596_);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public boolean m_7370_(LevelReader p_255715_, BlockPos p_52259_, BlockState p_52260_, boolean p_52261_) {
        return false;
    }

    public void m_214148_(ServerLevel p_221040_, RandomSource p_221041_, BlockPos p_221042_, BlockState p_221043_) {
        if (this.m_52305_(p_221043_) < this.m_7419_()) {
            p_221040_.m_7731_(p_221042_, this.m_52289_(this.m_52305_(p_221043_) + 1), 2);
        }
    }
}

